;;   manifold chunks routines
;;====================================================================
;; chunks.inc procedures list:
;;  delete_chunk
;;  detect chunks
;;  invert_normals_ch
;;  mirror chunk
;;  opt_chunks
;;  sort_chunks
mirror_chunk:
; in : eax - chunk no to mirror
                push   ebp
                mov    ebp,esp
                .cur_ch     equ dword[ebp-4]
                .pcv        equ dword[ebp-8]
                .tri_in_ch  equ dword[ebp-12]
                .tri_offset equ dword[ebp-16]
                .new_ptsI2  equ dword[ebp-20]
                .new_ptsI   equ dword[ebp-24]
                .vert_cnt   equ dword[ebp-28]
                .new_vert   equ dword[ebp-32]
                .new_tris   equ dword[ebp-36]
                .mxx        equ [ebp-80]

                cmp       eax,[chunks_count]
                jg        .end
                push      eax        ; cur ch
                push      [points_count_var]
                mov       esi,[chunks_ptr]
                mov       ecx,[triangles_count_var]
                cld
                xor       edx,edx
                xchg      ebx,eax
            .lab1:
                lodsw
                cmp       bx,ax
                je        @f
                loop      .lab1
            @@:
                inc       edx
                mov       edi,esi
                sub       edi,[chunks_ptr]
            .lab2:
                lodsw
                cmp       bx,ax
                je        @f
                loop      .lab2
                jmp       .en1
            @@:
                inc       edx
                loop      .lab2
            .en1:
                push      edx     ; tri in ch
                inc       edx
                ;  (edi-2)/2 - tris cnt to skip
                sub       edi,2
                add       edi,edi
                lea       edi,[edi*3]
                add       edi,[triangles_ptr]
                push      edi        ;  ebx - triangles offset in triangles list
                mov       ebx,edx ;ecx
                imul      ebx,12     ;  ebx - max vertices (size in mem) used in current chunk
                add       ebx,200
                malloc    ebx        ; vert index1
                push      eax
                malloc    ebx
                push      eax        ; vert index2
                cld
                mov       ecx,.tri_in_ch
                mov       esi,.tri_offset
                mov       edi,.new_ptsI2
                lea       ecx,[ecx*3]
                push      ecx
                rep       movsd
                mov       esi,.new_ptsI2
                mov       edi,.new_ptsI
                pop       ecx
                call      sort_hybrid_dd
                ; calc distinc verts count in cur chun
                mov       esi,.new_ptsI2
                mov       edi,.new_ptsI
                mov       ecx,.tri_in_ch
                lea       ecx,[ecx*3]
                xor       edx,edx
                mov       edx,1
                cld
            .bb1a:
                lodsd
                mov       ebx,[esi]
                cmp       ebx,eax
                jne       @f
                loop      .bb1a
                jmp       .fin1a
            @@:
                stosd
                inc       edx
                loop      .bb1a
            .fin1a:
                or        eax,-1
                stosd     ; end mark
                push      edx
                ;  edx - uniqe verts count in chunk
                ; .new_ptsI - sorted uniqe verts
                add       edx,.pcv  ;[points_count_var]
                imul      edx,12
                add       edx,128
                malloc    edx
                push      eax   ;new verts  whole list
                cvtdq2ps  xmm3,[xxadd]
                andps     xmm3,[zero_hgst]
                mov       esi,[points_rotated_ptr]
                mov       edi,eax
                mov       ecx,.pcv  ;[points_count_var]
            @@:
                movups    xmm0,[esi]
                subps     xmm0,xmm3
                movups    [edi],xmm0
                add       esi,12
                add       edi,12
                loop      @b
                cld
                ;compute new  tri list, fill new verts list with new positions
                mov      eax,1 shl 31
                movd     xmm2,eax      ; x axis related mirror
                ; it easy posible do y and z
                ;   shufps xmm2,xmm2,11110011b
                mov      esi,.tri_offset  ;.new_ptsI ;.tri_in_ch
                mov      ecx,.tri_in_ch
                lea      ecx,[ecx*3]
                mov      edi,.new_ptsI2
            .bbc:
                push     ecx
                lodsd
                cmp      eax,.pcv          ;[points_count_var]
                jnbe     .nxc
                push     edi
                mov      edx,eax
                imul     edx,12
                add      edx,.new_vert    ; [points_rotated_ptr]
                movups   xmm0,[edx]
                xorps    xmm0,xmm2        ; negate x cooef
                mov      edi,.new_ptsI
                or       ecx,-1           ;.vert_cnt  ;.tri_in_ch
                repne    scasd
                sub      edi,.new_ptsI
                shr      edi,2
                dec      edi
                mov      eax,edi
                pop      edi
                add      eax,.pcv         ;[points_count_var]
                mov      edx,eax
                imul     edx,12
                add      edx,.new_vert
                movlps   [edx],xmm0       ; new vertex in new_vert lst
                movhlps  xmm0,xmm0
                movss    [edx+8],xmm0
                stosd                   ; new vert index in .new_ptsI2 list
            .nxc:
                pop      ecx
                loop     .bbc
                ; new_ptsI2 - new chunk triangles
                mfree    .new_ptsI
                mov      ebx,.tri_in_ch
                add      ebx,[triangles_count_var]
                imul     ebx,12
                add      ebx,120
                malloc   ebx
                push     eax   ; new_tris - whole list of triangles
                cld
                mov      edi,eax
                mov      ecx,[triangles_count_var]
                mov      esi,[triangles_ptr]
                lea      ecx,[ecx*3]
                rep      movsd
                mov      esi,.new_ptsI2
                mov      ecx,.tri_in_ch
                lea      ecx,[ecx*3]
                rep      movsd
                mfree    .new_ptsI2
                mfree    [points_r_ptr]
                mfree    [triangles_ptr]
                mov      eax,.tri_in_ch
                mov      ebx,.vert_cnt
                add      [triangles_count_var],eax
                add      [points_count_var],ebx
                push     .new_tris
                pop      [triangles_ptr]
                sub      esp,60
                mov      esi,matrix
                lea      edi,.mxx
                call     reverse_mx_3x3
                mov      esi,.new_vert
                mov      edi,.new_vert
                mov      ecx,[points_count_var]
                lea      ebx,.mxx
                call     rotary
                push     .new_vert
                pop      [points_r_ptr]
              .end:
                mov      esp,ebp
                pop      ebp
                ret
;==============================================================
opt_chunks:
; optimize chunks
                push    ebp
                mov     ebp,esp
                sub     esp,76
                .piv_chu         equ [ebp-4]
                .piv_chu2        equ [ebp-8]
                .ptr_verts       equ [ebp-12]
                .cnt             equ [ebp-16]
                .ptr_nrm         equ [ebp-20]
                .cur_ch          equ [ebp-24]

                .t_offset        equ [ebp-28]   ;  \
                .v_offset        equ [ebp-32]   ;   |>  not xchg order
                .v_in_curr       equ [ebp-36]   ;   |>
                .t_in_curr       equ [ebp-40]   ;  /

                .chunks_count    equ dword[ebp-44]
                .chunks_desc_ptr equ dword[ebp-48]
                .greatest_chunk  equ dword[ebp-52]

                .chunks_ptr          equ dword[ebp-76]

                .points_normals_ptr  equ dword[ebp-72]  ;   \
                .points_count_var    equ dword[ebp-68]  ;    |
                .triangles_count_var equ dword[ebp-64]  ;     > not xchg order
                .points_r_ptr        equ dword[ebp-60]  ;    |
                .triangles_ptr       equ dword[ebp-56]  ;   /


                prompt  prompt_opt

                lea     esi,[points_normals_ptr]
                lea     edi,.points_normals_ptr
                mov     ecx,5
                rep     movsd
                mov     eax,[chunks_ptr]
                mov     ebx,[chunks_desc_ptr]
                mov     ecx,[chunks_count]
                mov     edx,[greatest_chunk]
                mov     .chunks_ptr,eax
                mov     .chunks_desc_ptr,ebx
                mov     .chunks_count,ecx
                cmp     ecx,1
                jle     .end
                mov     .greatest_chunk,edx

                shl     ecx,2
                add     ecx,5
                mov     edi,ebx
                xor     eax,eax
                cld
                rep     stosd
     if 1
                ; calculating values needed by version "b"
                ; t count, offset and greatest chunk
                xor     edx,edx
                mov     edi,.chunks_ptr
                movzx   ecx,word[edi+2] ; chunks_ptr list fix
                cmp     word[edi],dx    ;
                jne     @f              ;
                cmp     [edi+4],dx      ;
                je      @f              ;
                mov     [edi],cx        ;
               @@:
                mov     .t_offset,edx
                mov     ecx,.triangles_count_var
                mov     eax,1
             .loop_tri:
                push    eax
                mov     .cur_ch,eax
                ; for each chunk
                ; calc tris count and offset
                cld
                push    edi
                mov     ebx,edi
                sub     ebx,.chunks_ptr
                shr     ebx,1
                mov     .t_offset,ebx
                movzx   eax,word[edi]
                repe    scasw
                pop     ebx
                inc     ecx
                sub     edi,2
                mov     eax,edi

                sub     eax,ebx
                or      eax,eax
                jg      @f
                pop     eax       ; break eject
                jmp     .brk1     ;
              @@:
                shr     eax,1

         ;      mov     .t_in_curr,eax
                mov     ebx,eax
                cmp     eax,edx
                cmovg   edx,eax
                ; edx = max chunk

                mov     esi,.cur_ch
                shl     esi,4
                add     esi,.chunks_desc_ptr

                mov     [esi],ebx   ; tris in curr ch
                mov     ebx,.t_offset
                mov     [esi+12],ebx
                ; init tris count and tris offset
                pop     eax
                inc     eax
                cmp     eax,.chunks_count
                jbe     .loop_tri
              .brk1:
                mov     .greatest_chunk,edx   ; value calculated also in do_edges_list proc
                mov     [greatest_chunk],edx

     end if
                ;   [chunks_desc_ptr]
                ;   struct should have:     + 0 = count of tris in chunk
                ;   (for every chunk)       + 4 = count of vertices in chunk
                ;   call to opt_chunks      + 8 = vertices offset
                ;   to fill this struct     + 12 = triangles_offset
                mov     eax,.points_count_var
                add     eax,30
                imul    eax,12
                push    eax
                malloc  eax
                mov     .ptr_verts,eax
                pop     eax
                malloc  eax
                mov     .ptr_nrm,eax
                mov     eax,.greatest_chunk
                add     eax,90
                imul    eax,24
                push    eax
                malloc  eax
                mov     .piv_chu,eax
                pop     eax
                malloc  eax
                mov     .piv_chu2,eax
                xor     eax,eax
                mov     .cnt,eax
            ;   xor     ecx,ecx
                mov     ecx,1
              .loop_opt:
                push    ecx
                mov     .cur_ch,ecx
                cld
                mov     eax,.cnt
                mov     .v_offset,eax
            if 0
                ; version "a"
                mov     eax,ecx
                mov     edi,.chunks_ptr

                mov     ecx,.triangles_count_var
                repne   scasw
                sub     edi,2
                mov     esi,edi
                mov     ebx,edi
                sub     ebx,.chunks_ptr
                shr     ebx,1
                mov     .t_offset,ebx

                ; edi - start of curr chunk
                sub     esi,.chunks_ptr
                ;  (esi-2)/2 - tris cnt to skip
                imul    esi,6
                add     esi,.triangles_ptr
                push    esi
                ; esi = .t_offset
                push    edi
                add     edi,2
                or      ecx,-1
                mov     eax,.cur_ch
                repe    scasw
                pop     ebx
                sub     edi,ebx
                sub     edi,2
                shr     edi,1
                mov     .t_in_curr,edi
            end if
            if  1
                ; faster version "b" - whats a pity works bit invalid
                mov     eax,.cur_ch
                shl     eax,4
                add     eax,.chunks_desc_ptr
                mov     ebx,[eax]
                mov     .t_in_curr,ebx

                mov     ebx,[eax+12]
                mov     .t_offset,ebx
                imul    ebx,12
                add     ebx,.triangles_ptr
                push    ebx
            end if

                mov     ecx,.greatest_chunk
                add     ecx,10             ; zero pivot
                imul    ecx,6              ;
                xor     eax,eax            ;
                mov     edi,.piv_chu
                cld
                rep     stosd
                mov     ecx,.t_in_curr     ; t in cur chunk
                pop     esi
                or      ecx,ecx
                jz      .en_opt
                cmp     ecx,.triangles_count_var
                jg      .en_opt
                mov     edi,.piv_chu
                cld
             @@:
                mov     eax,esi
                ; esi = curr ptr to tri list
                movsd
                stosd
                mov     eax,esi
                movsd
                stosd
                mov     eax,esi
                movsd
                stosd
                loop    @b

                mov     ecx,.t_in_curr
                lea     ecx,[ecx*3]
                ; count of tris in curr chunk
                mov     esi,.piv_chu
                mov     edi,.piv_chu2
                call    sort_hybrid
              @@:
                mov     ecx,.t_in_curr
                lea     ecx,[ecx*3+1]
                xor     edx,edx
                mov     esi,.piv_chu
                cld
              @@:
                lodsd
                mov     ebx,eax
              @@:
                dec     ecx
                jz      .ecnt
                lodsd
                lodsd
                cmp     eax,ebx
                je      @b
                inc     edx
                mov     ebx,eax
                jmp     @b
              .ecnt:
                mov     ecx,edx
                mov     .v_in_curr,edx
                ; edx = distinct verts in chunk
                mov     esi,.piv_chu
              .nx_index:
                push    ecx
                ; .cnt = curr vert No
                cld
                lodsd   ; vert no
                mov     ebx,eax
                mov     edx,.cnt
                imul    eax,12
                imul    edx,12
                push    eax
                add     eax,.points_r_ptr
                movups  xmm0,[eax]
                pop     eax
                add     eax,.points_normals_ptr
                movups  xmm1,[eax]

                push    edx
                add     edx,.ptr_verts
                movups  [edx],xmm0
                pop     edx
                add     edx,.ptr_nrm
                movups  [edx],xmm1
                mov     eax,ebx
              @@:
                lodsd   ; vert ptr
                mov     edi,eax
                mov     eax,.cnt
                stosd
                lodsd
                cmp     eax,ebx
                jz      @b
            ;    jnz     @f
            ;    jmp     @b
            ;  @@:
                sub     esi,4
                ; Now all verts indices of curr index
                ; .cnt = curr vert No,
                ; are switched.
                inc     dword .cnt
                pop     ecx
                dec     ecx
                jnz     .nx_index

                mov     edi,.cur_ch
           ;    dec     edi
                shl     edi,4
                add     edi,.chunks_desc_ptr   ;  chunk desc struct starts from
                                               ;  + 16
                movups  xmm0,.t_in_curr        ;
                movups  [edi],xmm0

                pop     ecx
                inc     ecx
                cmp     ecx,.chunks_count
           ;    dec     ecx
           ;    jnz     .loop_opt
                jle     .loop_opt

             .en_opt:
                mfree   .piv_chu
                mfree   .piv_chu2
                mfree   .points_r_ptr
                mov     eax,.ptr_verts
                mov     [points_r_ptr],eax
                mfree   .points_normals_ptr
                mov     eax,.ptr_nrm
                mov     [points_normals_ptr],eax
                mov     eax,.cnt
                mov     [points_count_var],eax
              .end:
                cls
                mov     esp,ebp
                pop     ebp
ret
;==============================================================
;==============================================================
sort_chunks:
; sort chunks, sort triangles, triangles normal vectors
                push   ebp
                mov    ebp,esp
                .ptr1            equ [ebp-4]
                .ptr2            equ [ebp-8]
                .points_r        equ [ebp-12]
                .tcv             equ [ebp-16]
                .tptr            equ dword [ebp-20]
                .chunks_struct   equ dword [ebp-24]
                .chunks_structEx equ [ebp-28]
                .was_used        equ [ebp-32]
                .cnt             equ [ebp-36]
                .accum_tris      equ [ebp-40]


                mov      ebx,[chunks_count]
                cmp      ebx,1
                je       .end_one
                pushad
                call     remove_non_tri
                popad
                mfree    [chunks_desc_ptr]
                mfree    [chunk_desc_Ex_ptr]
                mov      ebx,[triangles_count_var]
                add      ebx,150
                imul     ebx,12
                ;    mov      eax,[edges_count]
                ;    add      eax,15
                ;    shl      eax,3
                ;    cmp      eax,ebx
                ;    cmovna   eax,ebx
                malloc   ebx
                push     eax   ; ptr1
                malloc   ebx
                push     eax   ; ptr2
                push     [points_r_ptr]
                push     [triangles_count_var]   ; .tcv
                push     [triangles_ptr]
                sub      esp,44
                mov      esi,[chunks_ptr]
                mov      edi,.ptr1
                xor      ecx,ecx
                cld
            @@:
                ;make pivot table
                lodsw
                movzx    eax,ax
                stosd
                mov      eax,ecx
                stosd
                inc      ecx       ; tri no
                cmp      ecx,.tcv  ; [triangles_count_var]
                jnz      @b
                mov      esi,.ptr1
                mov      edi,.ptr2
                mov      ecx,.tcv
                call     sort_hybrid
                mov      esi,.ptr1
                mov      edi,.ptr2
                mov      ebx,[chunks_ptr]
                mov      ecx,.tcv
                cld
            @@:
                lodsd
                mov      [ebx],ax         ; renew chunks, triangles lists
                lodsd
                push     esi
                imul     eax,12
                add      eax,.tptr        ; [triangles_ptr]
                mov      esi,eax
                movsd
                movsd
                movsd
                pop      esi
                add      ebx,2
                loop     @b
                mov      esi,.ptr1        ; renew tri normals list
                mov      edi,.tptr
                mov      ebx,[triangles_normals_ptr]
                mov      ecx,.tcv         ; [triangles_count_var]
                cld
            @@:
                lodsd
                lodsd
                imul     eax,12
                add      eax,ebx
                xchg     esi,eax
                movsd
                movsd
                movsd
                xchg     esi,eax
                loop     @b
                ; do chunks struct, renew points, triangles list, so -
                ; -  vert indexes/indices in tri list. Rearanging  vertices list,
                ; sort according to every chunk - opt_chunks proc..
                mov      ebx,[chunks_count]
                shl      ebx,4
                add      ebx,200
                malloc   ebx
                mov      .chunks_struct,eax
                shl      ebx,2
                malloc   ebx
                mov      .chunks_structEx,eax      ; max, min, avg vertices
                ; in chunk
                ;   or       eax,-1
                ;   mov      .chunks_struct,eax
                ;   mov      ebx,[chunks_count]
                ;   cmp      ebx,1
                ;   je       .end
                mov      ebx,[points_count_var]
                add      ebx,300
                malloc   ebx
                mov      .was_used,eax
                mov      edi,eax
                xor      eax,eax
                mov      .cnt,eax
                mov      .accum_tris,eax
                mov      ecx,ebx
                sub      ecx,3
                shr      ecx,2
                rep      stosd
                mov      edi,.chunks_struct       ; make chunks stuct
                mov      esi,[chunks_ptr]         ; every dword - triangles count in chunk
                mov      ecx,.tcv                 ; [triangles_count_var]
                mov      edx,.ptr2                ; [triangles_ptr]
                cld
                lodsw
                inc      dword[edi]
                dec      ecx
                jz       .lab2
                mov      bx,ax
                xorps    xmm0,xmm0
                xorps    xmm1,xmm1
                ;  movss     .cnt,xmm0
            .lab1:
                lodsw
                cmp      bx,ax
                jne      .nx_1
                inc      dword[edi]
                push     eax
                push     ebx
                push     ecx
                mov      ecx,3
            .tri_lab:
                mov      eax,[edx]
                mov      ebx,eax
                add      ebx,.was_used
                cmp      byte [ebx],0
                jne      .f_1
                mov      byte [ebx],1
                imul     eax,12
                add      eax,.points_r
                movups   xmm1,[eax]
                maxps    xmm0,xmm1
                minps    xmm2,xmm1
            .f_1:
                add      edx,4
                loop    .tri_lab
                pop      ecx
                pop      ebx
                pop      eax
                loop     .lab1
                or       ecx,ecx
                jz       .lab2
            .nx_1:
                push    edx
                xorps   xmm0,xmm0
                xorps   xmm2,xmm2
                mov     edx,.accum_tris
                mov     [edi+12],edx   ; tri offset
                add     edx,[edi]
                mov     .accum_tris,edx
                pop     edx
                add     edi,16
                inc     dword .cnt
                xchg    ebx,eax
                loop    .lab1
            .lab2:
            .end:
                mfree   .ptr1
                mfree   .was_used
                mfree   [triangles_normals_ptr]
                push    .chunks_struct
                pop     [chunks_desc_ptr]
                push    dword .chunks_structEx
                pop     [chunk_desc_Ex_ptr]
                push    [triangles_ptr]
                pop     [triangles_normals_ptr]
                push    dword .ptr2
                pop     [triangles_ptr]
             ;   call    opt_chunks
            .end_one:
                mov     esp,ebp
                pop     ebp
ret
;================================================================================
delete_chunk:
; in eax - chunks No to delete
; Need perform remove dead triangles and remove
; unused vertices at the end of process.
                mov    esi,[chunks_ptr]
                mov    ecx,[triangles_count_var]
                mov    edi,[triangles_ptr]
                xorps  xmm0,xmm0
                mov    bx,ax
                cld
           .nxx:
                lodsw
                cmp    bx,ax
                jne    @f
                movlps [edi],xmm0
                movss  [edi+8],xmm0
            @@:
                add    edi,12
                loop   .nxx
ret
;============================================================
invert_normals_ch:
; invert sense of normal vectors of selected chunk;
; in eax - index number of selected chunk
                mov     esi,[chunks_ptr]
                mov     ecx,[triangles_count_var]
                mov     edi,[triangles_ptr]
                mov     bx,ax
                cld
              .nxx:
                lodsw
                cmp     bx,ax
                jne     @f
                movlps  xmm0,[edi]
                shufps  xmm0,xmm0,11100001b
                movlps  [edi],xmm0
              @@:
                add     edi,12
                loop    .nxx
ret
;=========================================================================
detect_chunks:
; make pivot table, sort, remove unused vertices, find chunks...
; in  - some global variables and
;   eax = 0 or 1 - export or non export some lists
;   ebx = 0x33333333  -> make only pivot table
; out:
; if eax = 0
;      ebx - chunks list ptr
;      ecx - chunks number
; if eax = 1 above and -
;      esi - tri_ch    ; vertices with triangles list
;      edi - t_ptr     ; pointers to tri_ch list
                push ebp
                mov  ebp,esp
                sub  esp,68
                .tri_ch    equ dword[ebp-4]    ; tri chunks list ptr
                .chunks    equ dword[ebp-8]    ; chunks ptreach tri chunk No. as word
                .endt      equ dword[ebp-12]   ;
                .t_ptr     equ dword[ebp-16]   ; pointers list
                .tri_ch1   equ dword[ebp-20]   ;
                .up        equ dword[ebp-24]   ; upload ptr
                .chmr      equ dword[ebp-28]   ; bit mark list if tri stored
                .str       equ dword[ebp-32]   ; store ptr
                .ltch1     equ dword[ebp-36]   ; end of tri_ch1 ptr
                .ch_cnt    equ dword[ebp-40]
                .cntt      equ dword[ebp-44]
                .cc        equ dword[ebp-48]
                .lsparam   equ dword[ebp-52]
                .fix_mark  equ dword[ebp-56]
                .endVptr   equ dword[ebp-60]
                .pivot     equ dword[ebp-64]
                .old_esp   equ dword[ebp-68]
                mov     .lsparam,eax
                mov     .pivot,ebx
                call    remove_non_tri
                mov     .fix_mark,0
                mov     eax,[triangles_ptr]
                mov     ebx,[points_r_ptr]
                mov     ecx,[triangles_count_var]
                mov     edx,[points_count_var]
                call    remove_unused_vertices
                mov     [points_count_var],ecx
                prompt  prompt_det_chunks1 ; macro
                mov     ebx,[triangles_count_var]
                shl     ebx,3
                lea     ebx,[ebx*3]    ; 8 * 3 - 24 bytes ?
                add     ebx,65536
                malloc  ebx
                mov     .tri_ch,eax
                malloc  ebx
                mov     .tri_ch1,eax
                mov     ebx,[triangles_count_var]
                shl     ebx,4
                add     ebx,3000
                malloc  ebx
                mov     .t_ptr,eax
                mov     ebx,.pivot
                cmp     ebx,0x33333333
                je      .no_a
                cmp     ebx,0x33
                je      .no_a
                mov     ebx,[triangles_count_var]
                shl     ebx,1
                add     ebx,20
                malloc  ebx
                mov     .chunks,eax   ; each tri chunk No. as word
                shr     ebx,4
                malloc  ebx
                mov     .chmr,eax     ; chunks mark if bit is set - tri was used
                ;  .ag: ; again
                ;   mov     .fix_mark,0
            .ag:
                call    remove_non_tri
                mov     edi,.chmr
                xor     eax,eax
                mov     ecx,[triangles_count_var]
                cld
                shr     ecx,2 + 3
                inc     ecx
                rep     stosd
            .no_a:
                mov     eax,[points_count_var]
                imul    eax,12
                add     eax,[points_r_ptr]
                mov     .endVptr,eax
                ; make pivot table
                mov     edi,.tri_ch
                mov     esi,[triangles_ptr]
                xor     ecx,ecx
                cld
            @@:                      ; interlaved vert index, triangle index
                movsd
                mov     eax,ecx
                stosd
                movsd
                stosd
                movsd
                stosd
                inc     ecx
                cmp     ecx,[triangles_count_var]
                jnz     @b
                ; qsort
                mov     esi,.tri_ch
                mov     edi,.tri_ch1
                mov     ecx,[triangles_count_var]
                lea     ecx,[ecx*3]
                call    sort_hybrid
                mov     esi,.tri_ch
                mov     edi,esi
                mov     eax,[triangles_ptr]
                mov     ebx,[points_r_ptr]
                mov     ecx,[triangles_count_var]
                mov     edx,[points_count_var]
                call    remove_unused_vertices
                mov     [points_count_var],ecx
                mov     ecx,[triangles_count_var]
                lea     ecx,[ecx*3]
                mov     esi,ecx
                shl     esi,3
                add     esi,.tri_ch
                mov     .endt,esi
                prompt  prompt_det_chunks ; sec stage
            .do_ch:
                ;make t_ptr  - table with pointers/adresses
                mov     ecx,[points_count_var]
                mov     esi,.tri_ch
                mov     edi,.t_ptr
                mov     ebx,ecx
                mov     [edi],esi
                add     edi,4
                dec     ecx
                jz      .dn33
            .pt:
                mov     eax,[esi]        ; [esi]   - vert ind
                add     esi,8
                movss   xmm0,[esi+4]
                cmp     eax,[esi]        ; [esi+4] - tri ind
                je      @f
                mov     [edi],esi       ;  [edi] - pointer
                add     edi,4
                dec     ecx
                jz      .dn33
            @@:
                cmp     esi,.endt
                jb      .pt
            .dn33:
                mov     ebx,.pivot
                cmp     ebx,0x33333333
                je      .end2_piv
                cmp     ebx,0x33
                je      .end2_piv
                mov     edi,.t_ptr
                mov     ecx,[triangles_count_var]
                ;  mov     ebx,ecx
                ;  imul    ebx,12
                ;  add     edi,ebx
                ;  or      eax,-1
                ;  cld
                ;  stosd    ; mark
                ; each dword position in .t_ptr list - adress of corresponding
                ; triangles indexes, each triangles from such index contains this vertice
                ; search for chunks
                mov     eax,ecx     ; [triangles_count_var]
                mov     .cntt,eax   ; temp help cnt
                xor     ecx,ecx
                mov     .cc,ecx
                mov     esi,[triangles_ptr]
                mov     edi,.tri_ch1
                imul    eax,12
                shl     eax,3
                add     eax,edi
                mov     .ltch1,eax
                mov     .up,esi
                mov     .str,edi
            .lb1:
                ;  mov     edi,.str   ;           ; nx chunk
                cmp     edi,.ltch1
                jnb     .endl                  ; nb
                mov     .str,edi
                mov     eax,.cc
                mov     edx,.cc
                inc     .cc
                cmp     edx,[triangles_count_var]
                jz      .endl
                shr     eax,3
                and     edx,111b
                add     eax,.chmr
                xor     ebx,ebx
                bt      [eax],edx            ; mark
                jc      @f                   ; tri was stored
                inc     ecx
                or      ebx,1b
                mov     esi,.up
                movups  xmm0,[esi]
                movups  [edi],xmm0
                add     .str,12
            @@:
                add     .up,12
                or      ebx,ebx
                jz      .lb1
            .lb2:
                mov     eax,[edi]
                mov     edx,[edi]           ; edx - vert ind
                shl     eax,2
                add     eax,.t_ptr
                mov     eax,[eax]           ; [eax] -   t ptr
                or      eax,eax
                jz      .endl
            .nxt:
                mov     esi,[eax+4]
                mov     ebx,[eax+4]
                shr     esi,3
                and     ebx,111b
                add     esi,.chmr
                bts     [esi],ebx          ; mark
                jc      @f                 ; tri was stored
                dec     .cntt
                je      .endl
                mov     esi,[eax+4]        ; [eax+4] - tri ind
                add     esi,esi
                add     esi,.chunks
                mov     [esi],cx
                mov     esi,[eax+4]
                imul    esi,12
                add     esi,[triangles_ptr]
                movups  xmm0,[esi]
                mov     esi,.str
                movups  [esi],xmm0
                add     .str,12
            @@:
                add     eax,8
                cmp     edx,[eax]
                je      .nxt
                add     edi,4
                cmp     edi,.str
                jne     .lb2
                jmp     .lb1
            .endl:
                mov     .ch_cnt,ecx
            .end:
                cmp     .lsparam,1
                je      .ff1
                mfree   .t_ptr
                mfree   .tri_ch
            .ff1:
                mfree   .chmr
                mov     ebx,.chunks
            .end2_piv:
                mfree   .tri_ch1
                cmp     .pivot,0x33333333
                je      .ff2
                mov     ebx,.chunks
                mov     ecx,.ch_cnt
                jmp     .en2
            .ff2:
                or      ebx,-1
                or      ecx,-1
            .en2:
                mov     esi,.tri_ch
                mov     edi,.t_ptr
                cls     ;macro
                mov     esp,ebp
                pop     ebp
                ret
;==============================================================